<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
    <%@ page import="ch13.board.BoardDBBean" %>
    <%@ page import="ch13.board.BoardDataBean" %>
    <%@ page import="java.text.SimpleDateFormat" %>
    <%@ page import="java.util.List"%>
    <%@ include file="color.jspf" %>

<%
	int pageSize=10;
	SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd-HH-mm");
%>

<%
	String pageNum = request.getParameter("pageNum");
	
	if(pageNum==null){
		pageNum = "1";
	}
	
	int currentPage = Integer.parseInt(pageNum);
	int startRow = (currentPage-1)*pageSize + 1;
	int endRow = currentPage * pageSize;
	int count = 0;
	int number = 0;
	List <BoardDataBean> articleList = null;
	
	BoardDBBean dbPro = BoardDBBean.getInstance();
	count = dbPro.getArticleCount();
	
	if(count > 0){
		articleList = dbPro.getArticles(startRow, endRow);
	}
	
	number = count-(currentPage-1)*pageSize; // 이건 쩝;;
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>게시판</title>
<link href="style.css" rel="stylesheet" type="text/css">
<style>

/* UI Object */
#wrap{width:100%}
#header{width:100%}
#container{*display:inline-block;}
#container:after{display:block;clear:both;content:''}
#content{float:left;width:100%;margin-right:-200px}
.aside{float:right;position:relative;left:200px;width:180px}
#footer{width:100%}

/* Layout Color - 실제 서비스 적용 후 아래 코드는 삭제 하세요 */
div{margin:0 0 10px;padding:10px 0;color:#2d2c2d;font-family:Tahoma;font-size:14px;font-weight:bold}
#wrap{_float:left;position:relative;width:auto;margin:0;padding:10px;background:#f7f7f7}
#wrap{border:1px solid #bdbdbd}
#header{width:auto;margin-top:10px;padding:10px}
#header,#container{border:2px solid #bfbfbf;background:#e5e5e5}
#container{}
#content{position:relative;height:200px;margin-top:10px;border:1px solid #bdbdbd;background:#fff;text-align:center}
.aside{left:190px;width:170px;margin-top:10px;border:1px solid #bdbdbd;background:#fff;text-align:center}
#footer{clear:both;width:auto;padding:10px;border:2px solid #bfbfbf;background:#e5e5e5}
a { text-decoration:none }
/* //UI Object */
</style>
</head>
<body>
<p>글목록(전체글:<%=count %>)</p>
<br><br><br><br><br><br><br>

<% if(count == 0){ %>

<table>
	<tr>
		<td align="center">
			게시판에 저장된 글이 없습니다.
		</td>
	</tr>
</table>

<%}else{ %>
<table id="container">
	<tr height="30">
		<td align="center" width="50" style="background-color:#BDBDBD">번 호</td>
		<td align="center" width="250" style="background-color:#BDBDBD" >제 목</td>
		<td align="center" width="100" style="background-color:#BDBDBD" >작성자</td>
		<td align="center" width="150" style="background-color:#BDBDBD">작성일</td>
		<td align="center" width="50" style="background-color:#BDBDBD">조 회</td>
		<td align="center" width="100" style="background-color:#BDBDBD" >IP</td>
	</tr>
<%
	for(int i=0;i < articleList.size();i++){
		BoardDataBean article=articleList.get(i);
%>
	<tr height="30">
		<td width="50" style="background-color:#D5D5D5"><%=(i+1)+pageSize*(currentPage-1) %></td>
		<td width="250" align="left">
<%
	int wid=0;
	if(article.getRe_level()>0){
		wid=5*(article.getRe_level());
%>
	<img src="images/level.png" width="<%=wid %>" height="16">
	<img src="images/re.png">
<%}else{ %>
	<img src="images/level.png"  width="<%=wid %>" height="16">
<%}%>

<a href="content.jsp?num=<%=article.getNum()%>&pageNum=<%=currentPage%>"><%=article.getSubject() %></a>

<% if(article.getReadcount()>=20){ %>
	<img src="images/hot.png" border="0" height="16" > <%} %></td>
	<td width="100" align="left">
	<a href="mailto:<%=article.getEmail()%>"><%=article.getWriter() %></a></td>
	<td width="150"><%=sdf.format(article.getReg_date()) %></td>
	<td width="50"><%=article.getReadcount() %></td>
	<td width="100"><%=article.getIp() %></td>
</tr>
<%}%>
</table>
<%}%>
<div> 
<%
	if(count>0){
		int pageCount = count / pageSize + (count%pageSize==0?0:1);
		int startPage=1;
		
		if(currentPage%10!=0)
			startPage=(int)(currentPage/10)*10+1;
		else
			startPage=((int)(currentPage/10)-1)*10+1;
		int pageBlock = 10;
		int endPage = startPage + pageBlock - 1;
		if(endPage>pageCount)endPage=pageCount;
		
		if(startPage>10){%>
		<a href="list1.jsp?pageNum=<%=startPage-10%>">[이전]</a>
<% 	}
		for(int i=startPage;i<endPage+1;i++){%>
		<a href="list1.jsp?pageNum=<%=i%>">[<%=i %>]</a>
<%}
		if(endPage < pageCount){ %>
		<a href="list1.jsp?pageNum=<%= startPage +10 %>">[다음]</a>
<%
		}
	}
%>
</div>
<div style="position:relative;left:272px">
	<a style="border:0.5px solid black" href="goodlogin.jsp">개인화면가기</a>
	<a style="border:0.5px solid black" href="writeForm.jsp">글쓰기</a>
	<a style="border:0.5px solid black" href="download.jsp">다운로드하기</a>
</div>

</body>
</html>