install.packages("dplyr")
install.packages("ggplot2")
install.packages("readxl")
install.packages("plotly")

library(ggpl)
library(devtools)
library(dplyr)
library(ggplot2)
library(readxl)
library(plotly)
library(RColorBrewer)

store_201512_1 = read.csv("상가업소_201512/상가업소_201512_01.csv")
store_201512_3 = read.csv("상가업소_201512/상가업소_201512_03.csv")


##경기도/강원도/충청북도
gyeonggi_1512 <- store_201512_3 %>%  filter(시도명 == "경기도")
gangwon_1512 <- store_201512_3 %>%  filter(시도명 == "강원도")
chungbuk_1512 <- store_201512_3 %>%  filter(시도명 == "충청북도")
df_gyeonggi_1512 <-gyeonggi
df_gangwon_1512 <-gangwon
df_chungbuk_1512 <-chungbuk

##경기도
gy_big<-df_gyeonggi_1512 %>% group_by(상권업종대분류명) %>% summarise(count=n()) %>% arrange(desc(count)) %>% head(10)
gy_mid<-df_gyeonggi_1512 %>% group_by(상권업종중분류명) %>% summarise(count=n()) %>% arrange(desc(count)) %>% head(10)
ggplot(data=gy_big, aes(x=reorder(상권업종대분류명,count), y=count, fill=상권업종대분류명)) + geom_col(position = "dodge")+xlab("")+ylab("개수")+ggtitle("2015년 12월 경기도 상권업종대분류")+geom_text(aes(label=count), vjust=1.5, colour="white")+theme(plot.title = element_text(size=20,hjust = 0.5))
ggplot(data=gy_mid, aes(x=reorder(상권업종중분류명,count), y=count, fill=상권업종중분류명)) + geom_col(position = "dodge")+xlab("")+ylab("개수")+ggtitle("2015년 12월 경기도 상권업종중분류")+geom_text(aes(label=count), vjust=1.5, colour="white")+theme(plot.title = element_text(size=20,hjust = 0.5))
df_gd_gr_201512<- df_gyeonggi_1512 %>%
  group_by(상권업종대분류명, 상권업종중분류명) %>%
  summarise(n = n()) %>%
  mutate(big_gr = sum(n)) %>%
  arrange(desc(big_gr)) %>% 
  mutate(pct = round(n/big_gr*100,2))
gd_2015gr<-ggplot(data = df_gd_gr_201512, aes(reorder(상권업종대분류명,big_gr), y=pct, fill = 상권업종중분류명, )) + geom_col() + coord_flip() +xlab("대분류명")+ylab("비율")+ggtitle("2015년 12월 경기도 업종분류")+theme(plot.title = element_text(size=14, face="bold",color="black", hjust=0.5))
ggplotly(gd_2015gr)

##강원도
gw_big<-df_gangwon_1512 %>% group_by(상권업종대분류명) %>% summarise(count=n()) %>% arrange(desc(count)) %>% head(10)
gw_mid<-df_gangwon_1512 %>% group_by(상권업종중분류명) %>% summarise(count=n()) %>% arrange(desc(count)) %>% head(10)
ggplot(data=gw_big, aes(x=reorder(상권업종대분류명,count), y=count, fill=상권업종대분류명)) + geom_col(position = "dodge")+xlab("")+ylab("개수")+ggtitle("2015년 12월 강원도 상권업종대분류")+geom_text(aes(label=count), vjust=1.5, colour="white")+theme(plot.title = element_text(size=20,hjust = 0.5))
ggplot(data=gw_mid, aes(x=reorder(상권업종중분류명,count), y=count, fill=상권업종중분류명)) + geom_col(position = "dodge")+xlab("")+ylab("개수")+ggtitle("2015년 12월 강원도 상권업종중분류")+geom_text(aes(label=count), vjust=1.5, colour="white")+theme(plot.title = element_text(size=20,hjust = 0.5))
df_gw_gr_201512<- df_gangwon_1512 %>%
  group_by(상권업종대분류명, 상권업종중분류명) %>%
  summarise(n = n()) %>%
  mutate(big_gr = sum(n)) %>%
  arrange(desc(big_gr)) %>% 
  mutate(pct = round(n/big_gr*100,2))
gw_2015gr<-ggplot(data = df_gw_gr_201512, aes(reorder(상권업종대분류명,big_gr), y=pct, fill = 상권업종중분류명, )) + geom_col() + coord_flip() +xlab("대분류명")+ylab("비율")+ggtitle("2015년 12월 강원도 업종분류")+theme(plot.title = element_text(size=14, face="bold",color="black", hjust=0.5))
ggplotly(gw_2015gr)

##충청북도
cb_big<-df_chungbuk_1512 %>% group_by(상권업종대분류명) %>% summarise(count=n()) %>% arrange(desc(count)) %>% head(10)
cb_mid<-df_chungbuk_1512 %>% group_by(상권업종중분류명) %>% summarise(count=n()) %>% arrange(desc(count)) %>% head(10)
ggplot(data=cb_big, aes(x=reorder(상권업종대분류명,count), y=count, fill=상권업종대분류명)) + geom_col(position = "dodge")+xlab("")+ylab("개수")+ggtitle("2015년 12월 충청북도 상권업종분류")+geom_text(aes(label=count), vjust=1.5, colour="white")+theme(plot.title = element_text(size=20,hjust = 0.5))
ggplot(data=cb_mid, aes(x=reorder(상권업종중분류명,count), y=count, fill=상권업종중분류명)) + geom_col(position = "dodge")+xlab("")+ylab("개수")+ggtitle("2015년 12월 충청북도 상권업종분류")+geom_text(aes(label=count), vjust=1.5, colour="white")+theme(plot.title = element_text(size=20,hjust = 0.5))
df_cb_gr_201512<- df_chungbuk_1512 %>%
  group_by(상권업종대분류명, 상권업종중분류명) %>%
  summarise(n = n()) %>%
  mutate(big_gr = sum(n)) %>%
  arrange(desc(big_gr)) %>% 
  mutate(pct = round(n/big_gr*100,2))
cb_2015gr<-ggplot(data = df_cb_gr_201512, aes(reorder(상권업종대분류명,big_gr), y=pct, fill = 상권업종중분류명, )) + geom_col() + coord_flip() +xlab("대분류명")+ylab("비율")+ggtitle("2015년 12월 충청북도 업종분류")+theme(plot.title = element_text(size=14, face="bold",color="black", hjust=0.5))
ggplotly(cb_2015gr)


##서울/부산
seoul_1512 <- store_201512_1 %>%  filter(시도명 == "서울특별시")
busan_1512 <- store_201512_1 %>%  filter(시도명 == "부산광역시")
df_seoul_1512 <- seoul_1512
df_busan_1512 <- busan_1512


##부산광역시
bu_big<-df_busan_1512 %>% group_by(상권업종대분류명) %>% summarise(count=n()) %>% arrange(desc(count)) %>% head(10)
bu_mid<-df_busan_1512 %>% group_by(상권업종중분류명) %>% summarise(count=n()) %>% arrange(desc(count)) %>% head(10)
ggplot(data=bu_big, aes(x=reorder(상권업종대분류명,count), y=count, fill=상권업종대분류명)) + geom_col(position = "dodge")+xlab("")+ylab("개수")+ggtitle("2015년 12월 부산광역시 상권업종대분류")+geom_text(aes(label=count), vjust=1.5, colour="white")+theme(plot.title = element_text(size=20,hjust = 0.5))
ggplot(data=bu_mid, aes(x=reorder(상권업종중분류명,count), y=count, fill=상권업종중분류명)) + geom_col(position = "dodge")+xlab("")+ylab("개수")+ggtitle("2015년 12월 부산광역시 상권업종중분류")+geom_text(aes(label=count), vjust=1.5, colour="white")+theme(plot.title = element_text(size=20,hjust = 0.5))
df_bu_gr_201512<- df_busan_1512 %>%
  group_by(상권업종대분류명, 상권업종중분류명) %>%
  summarise(n = n()) %>%
  mutate(big_gr = sum(n)) %>%
  arrange(desc(big_gr)) %>% 
  mutate(pct = round(n/big_gr*100,2))
bu_2015gr<-ggplot(data = df_bu_gr_201512, aes(reorder(상권업종대분류명,big_gr), y=pct, fill = 상권업종중분류명, )) + geom_col() + coord_flip() +xlab("대분류명")+ylab("비율")+ggtitle("2015년 12월 부산광역시 업종분류")+theme(plot.title = element_text(size=14, face="bold",color="black", hjust=0.5))
ggplotly(bu_2015gr)


##서울특별시
se_big<-df_seoul_1512 %>% group_by(상권업종대분류명) %>% summarise(count=n()) %>% arrange(desc(count)) %>% head(10)
se_mid<-df_seoul_1512 %>% group_by(상권업종중분류명) %>% summarise(count=n()) %>% arrange(desc(count)) %>% head(10)
ggplot(data=se_big, aes(x=reorder(상권업종대분류명,count), y=count, fill=상권업종대분류명)) + geom_col(position = "dodge")+xlab("")+ylab("개수")+ggtitle("2015년 12월 서울특별시 상권업종대분류")+geom_text(aes(label=count), vjust=1.5, colour="white")+theme(plot.title = element_text(size=20,hjust = 0.5))
ggplot(data=se_mid, aes(x=reorder(상권업종중분류명,count), y=count, fill=상권업종중분류명)) + geom_col(position = "dodge")+xlab("")+ylab("개수")+ggtitle("2015년 12월 서울특별시 상권업종중분류")+geom_text(aes(label=count), vjust=1.5, colour="white")+theme(plot.title = element_text(size=20,hjust = 0.5))
df_su_gr_201512<- df_seoul_1512 %>%
  group_by(상권업종대분류명, 상권업종중분류명) %>%
  summarise(n = n()) %>%
  arrange(desc(n)) %>% 
  mutate(big_gr = sum(n)) %>%
  arrange(desc(big_gr)) %>% 
  mutate(pct = round(n/big_gr*100,2))
su_2015gr<-ggplot(data = df_su_gr_201512, aes( reorder(상권업종대분류명,big_gr), y=pct, fill = 상권업종중분류명, )) + geom_col() + coord_flip() +xlab("대분류명")+ylab("비율")+ggtitle("2015년 12월 서울특별시 업종분류")+theme(plot.title = element_text(size=14, face="bold",color="black", hjust=0.5))
ggplotly(su_2015gr)









