
library(ggplot2)
library(devtools)
library(dplyr)
library(ggplot2)
library(readxl)
library(plotly)
library(RColorBrewer)

store_201512_1 = read.csv("상가업소_201512/상가업소_201512_01.csv")
store_201612_1 = read.csv("상가업소_201612/상가업소_201612_01.csv")
store_201712_1 = read_excel("상가업소_201712/상가업소_201712_01.xlsx")
store_201812_1 = read.csv("상가업소_201812/상가업소_201812_01.csv")



##서울특별시
df_date_seoul_1512<- store_201512_1 %>%  filter(시도명 == "서울특별시") %>% 
  group_by(상권업종대분류명) %>% 
  summarise(n=n()) %>% 
  arrange(desc(n)) %>% 
  mutate(date = 2015)
df_date_seoul_1612<- store_201612_1 %>%  filter(시도명 == "서울특별시") %>% 
  group_by(상권업종대분류명) %>% 
  summarise(n=n()) %>% 
  arrange(desc(n)) %>% 
  mutate(date = 2016)
df_date_seoul_1712<- store_201712_1 %>%  filter(시도명 == "서울특별시" & 상권업종대분류명 != "스포츠") %>% 
  group_by(상권업종대분류명) %>% 
  summarise(n=n()) %>% 
  arrange(desc(n)) %>% 
  mutate(date = 2017)
df_date_seoul_1812<- store_201812_1 %>%  filter(시도명 == "서울특별시" & 상권업종대분류명 != "스포츠") %>% 
  group_by(상권업종대분류명) %>% 
  summarise(n=n()) %>% 
  arrange(desc(n)) %>% 
  mutate(date = 2018)

df_date_seoul <- bind_rows(df_date_seoul_1512,df_date_seoul_1612,df_date_seoul_1712,df_date_seoul_1812)
View(df_date_seoul)
su_line<-ggplot(df_date_seoul, aes(x=date, y=n, col=상권업종대분류명 ))+geom_line()+xlab("기간")+ylab("상권 수")+ggtitle("서울특별시 기간별 업종 수")+theme(plot.title = element_text(size=14, face="bold",color="black", hjust=0.5))
ggplotly(su_line)


##부산광역시
df_date_busan_1512<- store_201512_1 %>%  filter(시도명 == "부산광역시") %>% 
  group_by(상권업종대분류명) %>% 
  summarise(n=n()) %>% 
  arrange(desc(n)) %>% 
  mutate(date = 2015)
View(df_date_busan_1512)
df_date_busan_1612<- store_201612_1 %>%  filter(시도명 == "부산광역시") %>% 
  group_by(상권업종대분류명) %>% 
  summarise(n=n()) %>% 
  arrange(desc(n)) %>% 
  mutate(date = 2016)
df_date_busan_1712<- store_201712_1 %>%  filter(시도명 == "부산광역시" & 상권업종대분류명 != "스포츠") %>% 
  group_by(상권업종대분류명) %>% 
  summarise(n=n()) %>% 
  arrange(desc(n)) %>% 
  mutate(date = 2017)
df_date_busan_1812<- store_201812_1 %>%  filter(시도명 == "부산광역시" & 상권업종대분류명 != "스포츠") %>% 
  group_by(상권업종대분류명) %>% 
  summarise(n=n()) %>% 
  arrange(desc(n)) %>% 
  mutate(date = 2018)
df_date_busan <- bind_rows(df_date_busan_1512,df_date_busan_1612,df_date_busan_1712,df_date_busan_1812)

View(df_date_busan)
bu_line<-ggplot(df_date_busan, aes(x=date, y=n, col=상권업종대분류명 ))+geom_line()+xlab("기간")+ylab("상권 수")+ggtitle("부산광역시 기간별 업종 수")+theme(plot.title = element_text(size=14, face="bold",color="black", hjust=0.5))
ggplotly(bu_line)


##서울·부산
df_all<- bind_rows(df_date_seoul %>% mutate(area="서울"), df_date_busan %>% mutate(area="부산"))
all_store<- ggplot(df_all, aes(x=date, y=n, col=상권업종대분류명, fill=area ))+geom_line()+xlab("기간")+ylab("상권 수")+ggtitle("서울·부산 기간별 업종 수")+theme(plot.title = element_text(size=14, face="bold",color="black", hjust=0.5))
ggplotly(all_store)


