install.packages("readxl")
library(readxl)
install.packages("dplyr")
library(dplyr)
install.packages("ggplot2")
library(ggplot2)


test <- read.csv("123.csv")
View(test)


test <- test %>% filter(등급 == '기사')
View(test2)





# 전체만 표현된 데이터
Atest <- test %>% filter(성별 == '전체')
View(Atest)

Atest22 <- Atest[grep("20", Atest$연도),]
View(Atest22)

Atest3 <- Atest[grep("09~11", Atest$연도),]
View(Atest3)


# 성별, 필기접수, 실기접수 요약
Stest <- test %>% select(성별, 필기접수, 실기접수)
View(Stest)

# // 전체 필기, 실기 접수
AStest <- Stest %>% filter(성별== '전체')
View(AStest)

Atest2 <- Gtest[grep("20", Gtest$연도),]
View(Atest2)

sum(AStest %>% select(필기접수))

sum(AStest %>% select(실기접수))

# 여성 필기 접수, 실기 접수
GStest <- Stest %>% filter(성별== '여성')

sum(GStest %>% select(필기접수))

sum(GStest %>% select(실기접수))

# 남성 필기
sum(AStest %>% select(필기접수)) - sum(GStest %>% select(필기접수))

# 남성 실기
sum(AStest %>% select(실기접수)) - sum(GStest %>% select(실기접수))



# 가장 높은 필기접수 응시율
a <- Atest2 %>% filter(필기접수 == max(필기접수))
View(a)

a <- Atest2 %>% filter(실기접수 == max(실기접수))
View(a)

# 가장 낮은 응시율
a <- Atest2 %>% filter(필기접수 == min(필기접수))
View(a)

a <- Atest2 %>% filter(실기접수 == min(실기접수))
View(a)



#여성이 가장 많이 응시한 시험
Gtest <- test %>% filter(성별== '여성')
a <- Gtest %>% filter(필기접수 == max(필기접수))
View(a)


# 여성 ~ 제거버전
Gtest2 <- Gtest[grep("20", Gtest$연도),]
View(Gtest2)


a <- Gtest2 %>% filter(필기접수 == max(필기접수))
View(a)



#정보처리 여성 제외한 데이터
Gtestout <- Gtest2 %>% filter(종목 != '정보처리기사')
View(Gtestout)

Gtestout2 <- Gtestout %>% filter(종목 != '건축기사')

a <- Gtestout2 %>% filter(필기접수 == max(필기접수))
View(a)





#정보처리 기사 제외버전
Mtest <- Atest2 %>% filter(종목 != '정보처리기사')
View(Mtest)

Mtest2 <- Mtest %>% filter(종목 != '전기기사')
View(Mtest2)

#남성
a <-Mtest2 %>% filter(필기접수 == max(필기접수))
View(a)




#합격율

#합격율이 높았던 시험
#필기
a <- Atest2 %>% filter(필기합격률 == max(필기합격률))
View(a)

#실기
a <- Atest2 %>% filter(실기합격률 == max(실기합격률))
View(a)

#합격율이 낮았던 시험
#필기
a <- Atest2 %>% filter(필기합격률 == min(필기합격률))
View(a)

#실기
a <- Atest2 %>% filter(실기합격률 == min(실기합격률))
View(a)


#합격률2






#전체 합격률

#필기
sum(Atest$필기합격) / sum(Atest$필기응시)
#실시
sum(Atest$실기합격) / sum(Atest$실기응시)


#여성

#필기
sum(Gtest$필기합격) / sum(Gtest$필기응시)
#실기
sum(Gtest$실기합격) / sum(Gtest$실기응시)

#남성
(sum(Atest$필기합격) - sum(Gtest$필기합격)) / (sum(Atest$필기응시) - sum(Gtest$필기응시))
#필기

#실기
(sum(Atest$실기합격) - sum(Gtest$실기합격)) / (sum(Atest$실기응시) - sum(Gtest$실기응시))





#그래프 접수율
ok <- Atest %>% filter(연도 == '2016')



a <- Atest %>% select('종목','필기응시')
a <- arrange(a,desc(필기응시)) %>% head(10)
View(a)

ggplot(data = a, aes(x= reorder(종목, 필기응시), y= 필기응시)) + geom_col() + coord_flip()


ok <-Gtest2 %>% filter(연도 == '2016')
View(ok)

a <- ok %>% select('종목','필기응시')
a <- arrange(a,desc(필기응시)) %>% head(10)
View(a)

ggplot(data = a, aes(x= reorder(종목, 필기응시), y= 필기응시)) + geom_col() + coord_flip()



#그래프 합격율

#가장 합격률이 낮은 시험 2016
ok <- Atest %>% filter(연도 == '2016')
a <- ok %>% select('종목','실기합격률')
a <- arrange(a,(실기합격률)) %>% head(10)
View(a)

ggplot(data = a, aes(x= reorder(종목, 실기합격률), y= 실기합격률)) + geom_col() + coord_flip()

#가장 합격률이 높은 시험 2016
ok <- Atest %>% filter(연도 == '2016')
a <- ok %>% select('종목','실기합격률')
a <- arrange(a,desc(실기합격률)) %>% head(10)
View(ok)


#그래프 합격률 09~11
# 낮은

#필기


a <- Atest3 %>% select('종목','필기합격률')
a <- arrange(a,(필기합격률)) %>% head(10)
View(a)
ggplot(data = a, aes(x= reorder(종목, 필기합격률), y= 필기합격률)) + geom_col() + coord_flip()

#실기

a <- Atest3 %>% select('종목','실기합격률')
a <- arrange(a,(실기합격률)) %>% head(10)
ggplot(data = a, aes(x= reorder(종목, 실기합격률), y= 실기합격률)) + geom_col() + coord_flip()
View(a)


#높음


a <- Atest3 %>% select('종목','필기합격률')
a <- arrange(a,desc(필기합격률)) %>% head(10)
View(a)


ggplot(data = a, aes(x= reorder(종목, 필기합격률), y= 필기합격률)) + geom_col() + coord_flip()

#실기

a <- Atest3 %>% select('종목','실기합격률')
a <- arrange(a,desc(실기합격률)) %>% head(10)
View(a)
ggplot(data = a, aes(x= reorder(종목, 실기합격률), y= 실기합격률)) + geom_col() + coord_flip()

## 응시률 그래프
성별 <- c('남성', '여성')
응시률 <-c(sum(AStest %>% select(필기접수)) - sum(GStest %>% select(필기접수)),sum(GStest %>% select(필기접수)))

sc <- data.frame(성별, 응시률)
View(sc)

ggplot(data=sc, aes(x= 성별, y= 응시률)) + geom_col()

# 합격률 그래프

#필기
필기합격률 <- c((sum(Atest$필기합격) - sum(Gtest$필기합격))
  / (sum(Atest$필기응시) - sum(Gtest$필기응시)), sum(Gtest$필기합격) / sum(Gtest$필기응시))
tc1 <- data.frame(성별, 필기합격률)
View(tc1)

ggplot(data=sc, aes(x= 성별, y= 필기합격률)) + geom_col()

#실기
실기합격률 <- c((sum(Atest$실기합격) - sum(Gtest$실기합격))
  / (sum(Atest$실기응시) - sum(Gtest$실기응시)), sum(Gtest$실기합격) / sum(Gtest$실기응시))
tc2 <- data.frame(성별, 실기합격률)
View(tc2)

ggplot(data=sc, aes(x= 성별, y= 실기합격률)) + geom_col()

dd <- Atest22 %>% filter(종목 == '정보처리기사')
View(dd)

group=1
ggplot(data=dd, aes(x=연도, y=필기합격률, group=1)) + geom_line() + ylim(0.2,0.8)

