
############################### 1. 패키지 설치하기

## 1-a. 파일 설정하기
install.packages("readxl")
library(readxl)

## 1-b. 그래프 만들기
install.packages("ggplot2")
library(ggplot2)

## 1-c. 파일 이름 변경
install.packages("dplyr")
library(dplyr)

## 1-d. 
install.packages("packcircles")
library(packcircles)

## 1-e.
install.packages("viridis")
library(viridis)





############################### 2. 엑셀파일불러오기

## 2-a. 엑셀파일 read
autonomous <- read_excel("자치구단위 서울 생활인구 일별 집계표.xlsx")
subway <- read_excel("서울시 지하철호선별 역별 승하차 인원 정보.xlsx")
address <- read_excel("서울교통공사 지하철역 주소 및 전화번호 정보.xlsx")

## 2-b. CSV 파일로 변경
autonomous_c <- write.csv(autonomous, file = "autonomous.csv")
autonomous_ <- read.csv("autonomous.csv", stringsAsFactors = F) #복사본

subway_c <- write.csv(subway, file = "subway.csv")
subway_ <- read.csv("subway.csv", stringsAsFactors = F) #복사본

address_c <- write.csv(address, file = "address.csv")
address_ <- read.csv("address.csv", stringsAsFactors = F) #복사본

## 2-c. 복사본 확인하기
View(autonomous_)
View(subway_)
View(address_)




############################### 3. 이름변경

## 3-a. autonomous_ 의 열제목 이름변경하기
autonomous_ <- rename(autonomous_, 번호 = X)
autonomous_ <- rename(autonomous_, 날짜 = 기준일ID)
autonomous_ <- rename(autonomous_, 총인구수 = 총생활인구수)

## 3-b. subway_ 의 열제목 이름변경하기
subway_ <- rename(subway_, 번호 = X)
subway_ <- rename(subway_, 날짜 = 사용일자)
subway_ <- rename(subway_, 승차 = 승차총승객수)
subway_ <- rename(subway_, 하차 = 하차총승객수)

## 3-c. address_ 의 열제목 이름변경하기
address_ <- rename(address_, 번호 = X)




############################### 4. 필요한 데이터 추출하기 (autonomous_)

autonomous_190608 <- autonomous_ %>%
                     filter(날짜 == '20190608', 시군구명 != '서울시') %>%
                     select(날짜, 시군구명, 총인구수) %>% 
                     arrange(desc(총인구수))

View(autonomous_190608)





############################### 5. 필요한 데이터 추출하기 (subway_)

subway_190608 <- subway_ %>%
                 filter(날짜 == '20190608') %>%
                 select(날짜, 호선명, 역명, 승차, 하차) %>%
                 mutate(총승하차 = 승차 + 하차) %>%
                 arrange(desc(총승하차))

View(subway_190608)





############################### 6. autonomous_190608 그래프

## 6-a. 자치구별 데이터프레임 생성
autonomous_190608_chart <- data.frame(group=autonomous_190608$시군구명, value=autonomous_190608$총인구수) 

## 6-b. 자치구별 인구 수 반지름 만들기
packing <- circleProgressiveLayout(autonomous_190608_chart$value, sizetype='area')
autonomous_190608_chart = cbind(autonomous_190608_chart, packing)
dat.gg <- circleLayoutVertices(packing, npoints=50)

## 6-c. ggplot2를 이용한 원의 색 지정하기
autonomous_190608_chart_circle <- ggplot() + 
  geom_polygon(data = dat.gg, aes(x, y, group = id, fill=as.factor(id)), colour = "black", alpha = 0.6) +
  scale_fill_manual(values = magma(nrow(autonomous_190608_chart))) +
  geom_text(data = autonomous_190608_chart, aes(x, y, size=value, label = group)) +
  scale_size_continuous(range = c(1,4)) +
  theme_void() + 
  theme(legend.position="none") +
  coord_equal()

## 6-d. [결과] 자치구별 원으로 된 표
autonomous_190608_chart_circle





############################### 7. subway_190608 그래프

## 7-a. 지하철 호선명 데이터 프레임 생성
subway_190608_chart <- subway_190608 %>% 
                       group_by(호선명) %>%   #호선별 그룹 지어주기
                       summarise(mean_총 = mean(총승하차)) %>%   #총승하차의 평균
                       arrange(desc(mean_총)) #높은순대로 정렬

View(subway_190608_chart)

subway_190608_chart <- as.data.frame(subway_190608_chart)

## 7-b. 
subway_190608_chart_graph <- ggplot(data = subway_190608_chart,
                                    aes(x = subway_190608_chart$호선명,
                                        y = subway_190608_chart$mean_총)) +
                             geom_col(aes(fill = 호선명)) + coord_flip()

## 7-c. [결과] 호선별 그래프
subway_190608_chart_graph                                                                      





############################### 8. 5개의 이용이 많은 호선

## 8-a. 2호선
subway_190608_2 <- subway_190608 %>% 
                   filter(호선명 == '2호선') %>% head(5)

View(subway_190608_2)

## 8-b. 1호선
subway_190608_1 <- subway_190608 %>% 
                   filter(호선명 == '1호선') %>% head(5)

View(subway_190608_1)

## 8-c. 4호선
subway_190608_4 <- subway_190608 %>% 
                   filter(호선명 == '4호선') %>% head(5)

View(subway_190608_4)

## 8-d. 3호선
subway_190608_3 <- subway_190608 %>% 
                   filter(호선명 == '3호선') %>% head(5)

View(subway_190608_3)





############################### 9. 역 주소 데이터 추출하기

## 9-a. subway_190608_2 에 있는 역의 주소만 추출
address_subway_2 <- address_ %>%
                    filter(호선 == '2호선' & 
                           역명 %in% c('홍대입구', '강남', '잠실(송파구청)', '신림', '신도림')) %>%
                    select(호선, 역명, 구주소)

View(address_subway_2)

## 9-b. subway_190608_1 에 있는 역의 주소만 추출
address_subway_1 <- address_ %>%
                    filter(호선 == '1호선' & 
                           역명 %in% c('서울역', '종로3가', '종각', '종로5가', '청량리(서울대입구)')) %>%
                    select(호선, 역명, 구주소)

View(address_subway_1)

## 9-c. subway_190608_4 에 있는 역의 주소만 추출
address_subway_4 <- address_ %>%
                    filter(호선 == '4호선' & 
                           역명 %in% c('명동', '혜화', '수유(강북구청)', '회현(남대문시장)', '미아사거리')) %>%
                    select(호선, 역명, 구주소)

View(address_subway_4)

## 9-d. subway_190608_3 에 있는 역의 주소만 추출
address_subway_3 <- address_ %>%
                    filter(호선 == '3호선' & 
                           역명 %in% c('고속터미널', '연신내', '신사', '남부터미널(예술의전당)', '압구정')) %>%
                    select(호선, 역명, 구주소)

View(address_subway_3)





############################### 10. 호선별 주소 데이터 조인하기



## 10-a. 2호선
subway_And_address_2 <- left_join(subway_190608_2, address_subway_2, by = "역명") 
subway_And_address_2 <- subway_And_address_2 %>%
                        select(날짜, 호선명, 역명, 총승하차, 구주소)

View(subway_And_address_2)

## 10-b. 1호선
subway_And_address_1 <- left_join(subway_190608_1, address_subway_1, by = "역명") 
subway_And_address_1 <- subway_And_address_1 %>%
                        select(날짜, 호선명, 역명, 총승하차, 구주소)

View(subway_And_address_1)

## 10-c. 4호선
subway_And_address_4 <- left_join(subway_190608_4, address_subway_4, by = "역명") 
subway_And_address_4 <- subway_And_address_4 %>%
                        select(날짜, 호선명, 역명, 총승하차, 구주소)

View(subway_And_address_4)

## 10-d. 3호선
subway_And_address_3 <- left_join(subway_190608_3, address_subway_3, by = "역명") 
subway_And_address_3 <- subway_And_address_3 %>%
                        select(날짜, 호선명, 역명, 총승하차, 구주소)

View(subway_And_address_3)





############################### 11. 전체 데이터 합치기
subway_And_address_All <- bind_rows(subway_And_address_2, subway_And_address_1, 
                                    subway_And_address_4, subway_And_address_3)
subway_And_address_All <- subway_And_address_All %>% arrange(desc(총승하차))

View(subway_And_address_All)








