apartment_price_rural <- read.csv("apartment_price_rural.csv",
                                  stringsAsFactors = F,
                                  fileEncoding = "euc-kr",
                                  encoding = "utf-8")

rural <- apartment_price_rural
View(rural)
rural <- rural[, -c(1)]

colnames(rural) <- NULL
rownames(rural) <- NULL
View(rural)

rural <- t(rural)
View(rural)

size <- c("super_small", "small", "mid_small", "mid_large", "large")
timing <- c("16.Feb", "16.Mar", "16.Apr", "16.May", "16.Jun", "16.Jul", "16.Aug", "16.Sep", "16.Oct", "16.Nov", "16.Dec",
            "17.Jan", "17.Feb", "17.Mar", "17.Apr", "17.May", "17.Jun", "17.Jul", "17.Aug", "17.Sep", "17.Oct", "17.Nov", "17.Dec",
            "18.Jan", "18.Feb", "18.Mar", "18.Apr", "18.May", "18.Jun", "18.Jul", "18.Aug", "18.Sep", "18.Oct", "18.Nov", "18.Dec",
            "19.Jan", "19.Feb")

rural <- cbind(timing, rural)
colnames(rural) <- c("timing", size)
View(rural)

rural <- data.frame(rural)

library(reshape2)
rural_ = melt(id=1, data=rural)
head(rural_)

colnames(rural_) <- c("timing", "size", "price")
head(rural_)

library(ggplot2)
ggplot(data = rural_, aes(x=timing, y=price, group=size)) + geom_line()
