apartment_price_urban <- read.csv("apartment_price_urban.csv",
                                  stringsAsFactors = F,
                                  fileEncoding = "euc-kr",
                                  encoding="utf-8")
View(apartment_price_urban)

urban <- apartment_price_urban
View(urban)

urban$X16.1Q <- urban$X16.Feb + urban$X16.Mar
urban$X16.2Q <- urban$X16.Apr + urban$X16.May + urban$X16.Jun
urban$X16.3Q <- urban$X16.Jul + urban$X16.Aug + urban$X16.Sep
urban$X16.4Q <- urban$X16.Oct + urban$X16.Nov + urban$X16.Dec
urban$X17.1Q <- urban$X17.Jan + urban$X17.Feb + urban$X17.Mar
urban$X17.2Q <- urban$X17.Apr + urban$X17.May + urban$X17.Jun
urban$X17.3Q <- urban$X17.Jul + urban$X17.Aug + urban$X17.Sep
urban$X17.4Q <- urban$X17.Oct + urban$X17.Nov + urban$X17.Dec
urban$X18.1Q <- urban$X18.Jan + urban$X18.Feb + urban$X18.Mar
urban$X18.2Q <- urban$X18.Apr + urban$X18.May + urban$X18.Jun
urban$X18.3Q <- urban$X18.Jul + urban$X18.Aug + urban$X18.Sep
urban$X18.4Q <- urban$X18.Oct + urban$X18.Nov + urban$X18.Dec
urban$X19.1Q <- urban$X19.Jan + urban$X19.Feb

urban$X16.1Q <- urban$X16.1Q / 2
urban$X16.2Q <- urban$X16.2Q / 3
urban$X16.3Q <- urban$X16.3Q / 3
urban$X16.4Q <- urban$X16.4Q / 3
urban$X17.1Q <- urban$X17.1Q / 3
urban$X17.2Q <- urban$X17.2Q / 3
urban$X17.3Q <- urban$X17.3Q / 3
urban$X17.4Q <- urban$X17.4Q / 3
urban$X18.1Q <- urban$X18.1Q / 3
urban$X18.2Q <- urban$X18.2Q / 3
urban$X18.3Q <- urban$X18.3Q / 3
urban$X18.4Q <- urban$X18.4Q / 3
urban$X19.1Q <- urban$X19.1Q / 2
View(urban)

urban <- urban[, -c(1:38)]
View(urban)

colnames(urban) <- NULL
rownames(urban) <- NULL
View(urban)

size <- c("XS", "S", "M", "L", "XL")
timing <- c("16.1Q", "16.2Q", "16.3Q", "16.4Q",
            "17.1Q", "17.2Q", "17.3Q", "17.4Q",
            "18.1Q", "18.2Q", "18.3Q", "18.4Q",
            "19.1Q")

urban <- t(urban)
urban <- data.frame(urban)
View(urban)

colnames(urban) <- size
rownames(urban) <- timing
View(urban)

urban <- t(urban)
urban <- data.frame(urban)
View(urban)

average_urban <- c(mean(urban$X16.1Q), mean(urban$X16.2Q), mean(urban$X16.3Q), mean(urban$X16.4Q),
             mean(urban$X17.1Q), mean(urban$X17.2Q), mean(urban$X17.3Q), mean(urban$X17.4Q),
             mean(urban$X18.1Q), mean(urban$X18.2Q), mean(urban$X18.3Q), mean(urban$X18.4Q),
             mean(urban$X19.1Q))

urban <- rbind(urban, average_urban)
View(urban)

urban <- urban[-c(1:5),]
rownames(urban) <- "avg"
View(urban)

urban <- t(urban)
urban <- data.frame(urban)
View(urban)

rownames(urban) <- NULL
colnames(urban) <- NULL
View(urban)

urban <- cbind(timing, urban)
colnames(urban) <- c("timing", "avg")
rownames(urban) <- timing
View(urban)

library(reshape2)
urban_ = melt(id=1, data=urban)
head(urban_)
colnames(urban_) <- c("timing", "size_avg", "price")
head(urban_)

library(ggplot2)
ggplot(data=urban_, aes(x=timing, y=price, group=size_avg)) + geom_line()
