library(ggplot2)
library(dplyr)

ggplot(data = urban_, aes(x=timing, y=price, group=size_avg)) + geom_line()
ggplot(data=rate, aes(x=timing, y=rate, group=default)) + geom_line()

install.packages("devtools")
devtools::install_github('trinker/plotflow')
library(plotflow)

plotflow::ggdual_axis(
  ggplot(data=urban_, aes(x=timing, y=price, group=size_avg)) + geom_line(color = 'red'),
  ggplot(data=rate, aes(x=timing, y=rate, group=default)) + geom_line(color = 'blue')
)
