install.packages('readxl') #엑셀파일 읽기
library(readxl)
install.packages('dplyr') # 데이터 처리
library(dplyr)
install.packages('ggplot2') # 그래프
library(ggplot2)
library(stringi) # 문자데이터 처리
install.packages("gridExtra") # 화면에 두개의 그래프를 띄우기 위해
library(gridExtra)
list_rest <- read_excel("C:/Users/Admin/Desktop/최종/20172311/rest.xls")
View(list_rest)

summary(list_rest)
mode(list_rest)

df_rest <- data.frame(list_rest) # list형식의 엑셀파일을 데이터프레임 형태로 만듦 
df_rest
View(df_rest)

df_fan <- df_rest %>%
  select(선풍기보유대수)
df_fan

df_fanNum <- as.numeric(df_fan$선풍기보유대수)
df_fanNum
is.na(df_fanNum)

fanNum <- na.omit(df_fanNum)
mean(fanNum)

df_air <- df_rest %>%
  select(에어컨보유대수)
df_air

df_airNum <- as.numeric(df_air$에어컨보유대수)
df_airNum
is.na(df_airNum)

airNum <- na.omit(df_airNum)
mean(airNum)

df_rest1 <- df_rest %>%
  select(법정동명, 쉼터유형구분, 시설면적, 이용가능인원수, 선풍기보유대수, 에어컨보유대수, 운영종료일자)

df_rest1

View(df_rest1)

df_gunpo <- df_rest1 %>%
  filter(grepl("..군포시", df_rest1$법정동명))
df_gunpo

df_gunpo$법정동명 <- recode(df_gunpo$법정동명, "경기도 군포시 대야미동 659-1" = "경기도 군포시 대야미동")
df_gunpo$법정동명 <- recode(df_gunpo$법정동명, "경기도 군포시 대야미동 662-2" = "경기도 군포시 대야미동")
df_gunpo$선풍기보유대수 <- as.numeric(df_gunpo$선풍기보유대수)
df_gunpo$에어컨보유대수 <- as.numeric(df_gunpo$에어컨보유대수)
df_gunpo$시설면적 <- as.numeric(df_gunpo$시설면적)
df_gunpo$이용가능인원수 <- as.numeric(df_gunpo$이용가능인원수)
df_gunpo$시설면적 <- na.omit(df_gunpo$시설면적)
df_gunpo$이용가능인원수 <- na.omit(df_gunpo$이용가능인원수)
df_gunpo[, c("선풍기보유대수", "에어컨보유대수")][is.na(df_gunpo[,c("선풍기보유대수", "에어컨보유대수")])] <- 0
mode(df_gunpo$운영종료일자)
df_gunpo <- df_gunpo %>%
  filter(grepl("2019..", df_gunpo$운영종료일자))
df_gunpo <- df_gunpo[c(order(df_gunpo$법정동명)),]
df_gunpo

View(df_gunpo)

dim(df_gunpo)
mean(df_gunpo$선풍기보유대수)
mean(df_gunpo$에어컨보유대수)

a1 = ggplot(data = df_gunpo, aes(x = 법정동명, y = 선풍기보유대수, fill = 법정동명)) + 
  geom_col() +
  coord_flip()
a2 = ggplot(data = df_gunpo, aes(x = 법정동명, y = 에어컨보유대수, fill = 법정동명)) + 
  geom_col() +
  coord_flip()
grid.arrange(a1, a2, nrow = 2)

df_gunpo1 <- df_gunpo %>%
  filter(df_gunpo$쉼터유형구분 == "노인시설")

df_gunpo1
dim(df_gunpo1)
